<?php
include "koneksi.php";

$error = "";
$token_valid = false;
$user = null;

// Cek token
if(!isset($_GET['token'])){
    $error = "Token tidak valid. Silakan request reset password lagi.";
} else {
    $token = mysqli_real_escape_string($koneksi, $_GET['token']);
    $q = mysqli_query($koneksi, "SELECT * FROM users 
        WHERE reset_token='$token' 
        AND reset_expired > NOW()");
    
    if(mysqli_num_rows($q) == 0){
        $error = "Token kadaluarsa atau tidak valid. Silakan request reset password lagi.";
    } else {
        $token_valid = true;
        $user = mysqli_fetch_assoc($q);
    }
}

// Proses reset password
if($token_valid && isset($_POST['simpan'])){
    $password = $_POST['password'];
    $password_confirm = $_POST['password_confirm'];
    
    if($password !== $password_confirm){
        $error = "Password dan konfirmasi password tidak sama!";
    } elseif(strlen($password) < 6){
        $error = "Password minimal 6 karakter!";
    } else {
        $password_hash = password_hash($password, PASSWORD_DEFAULT);
        
        mysqli_query($koneksi, "UPDATE users SET 
            password='$password_hash',
            password_text='$password',
            reset_token=NULL,
            reset_expired=NULL
            WHERE id_user='".$user['id_user']."'");
        
        $success = true;
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password - SIM Toko</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 450px;
            width: 100%;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .header h1 {
            color: #333;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .header p {
            color: #666;
            font-size: 14px;
        }
        
        .icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 40px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
        }
        
        input[type="password"],
        input[type="text"] {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 15px;
            transition: all 0.3s;
        }
        
        input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        button {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        
        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        
        button:active {
            transform: translateY(0);
        }
        
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #f5c6cb;
        }
        
        .success {
            background: #d4edda;
            color: #155724;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #c3e6cb;
            text-align: center;
        }
        
        .success a {
            display: inline-block;
            margin-top: 15px;
            padding: 10px 30px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            transition: transform 0.2s;
        }
        
        .success a:hover {
            transform: translateY(-2px);
        }
        
        .info-box {
            background: #e3f2fd;
            border-left: 4px solid #2196F3;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            font-size: 13px;
            color: #0d47a1;
        }
        
        .show-password {
            margin-top: 10px;
        }
        
        .show-password label {
            display: inline;
            font-weight: normal;
            cursor: pointer;
            user-select: none;
        }
        
        .show-password input[type="checkbox"] {
            width: auto;
            margin-right: 5px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if(isset($success) && $success): ?>
            <div class="header">
                <div class="icon">✅</div>
                <h1>Berhasil!</h1>
            </div>
            
            <div class="success">
                <strong>Password berhasil direset!</strong><br>
                Silakan login dengan password baru Anda.
                <br>
                <a href="login.php">🔑 Login Sekarang</a>
            </div>
            
        <?php elseif($error): ?>
            <div class="header">
                <div class="icon">❌</div>
                <h1>Error</h1>
            </div>
            
            <div class="error">
                <?= $error ?>
            </div>
            
            <div style="text-align: center;">
                <a href="lupa_password.php" style="color: #667eea; text-decoration: none;">
                    ← Request Reset Password Lagi
                </a>
            </div>
            
        <?php else: ?>
            <div class="header">
                <div class="icon">🔑</div>
                <h1>Reset Password</h1>
                <p>Masukkan password baru Anda</p>
            </div>
            
            <div class="info-box">
                ℹ️ Password minimal 6 karakter. Gunakan kombinasi huruf dan angka untuk keamanan.
            </div>
            
            <form method="POST">
                <div class="form-group">
                    <label for="password">Password Baru</label>
                    <input 
                        type="password" 
                        id="password"
                        name="password" 
                        placeholder="Masukkan password baru" 
                        required
                        minlength="6"
                    >
                </div>
                
                <div class="form-group">
                    <label for="password_confirm">Konfirmasi Password</label>
                    <input 
                        type="password" 
                        id="password_confirm"
                        name="password_confirm" 
                        placeholder="Masukkan ulang password baru" 
                        required
                        minlength="6"
                    >
                </div>
                
                <div class="show-password">
                    <label>
                        <input type="checkbox" onclick="togglePassword()">
                        Tampilkan password
                    </label>
                </div>
                
                <br>
                <button type="submit" name="simpan">
                    💾 Simpan Password Baru
                </button>
            </form>
        <?php endif; ?>
    </div>
    
    <script>
        function togglePassword() {
            var password = document.getElementById('password');
            var confirm = document.getElementById('password_confirm');
            
            if (password.type === 'password') {
                password.type = 'text';
                confirm.type = 'text';
            } else {
                password.type = 'password';
                confirm.type = 'password';
            }
        }
    </script>
</body>
</html>
