<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'kasir'){
    exit("Akses ditolak!");
}

$id_transaksi = intval($_GET['id_transaksi']);
$transaksi = mysqli_fetch_assoc(mysqli_query($koneksi,"SELECT * FROM transaksi WHERE id_transaksi=$id_transaksi"));
$details = mysqli_query($koneksi,"SELECT * FROM transaksi_detail WHERE id_transaksi=$id_transaksi");

// Ambil tanggal saja
$tanggal_only = date('Y-m-d', strtotime($transaksi['tanggal']));
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Struk Transaksi</title>
<style>
body{font-family:'Segoe UI',sans-serif;background:#f4f6f9;padding:20px;}
.container{max-width:700px;margin:auto;background:#fff;padding:25px;border-radius:10px;box-shadow:0 5px 20px rgba(0,0,0,0.1);}
h2{text-align:center;color:#2c3e50;margin-bottom:20px;}
table{width:100%;border-collapse:collapse;margin-bottom:20px;}
th,td{padding:10px;text-align:center;border:1px solid #ddd;}
th{background:#2c3e50;color:#fff;}
tfoot td{font-weight:bold;}
.btn{display:inline-block;background:#27ae60;color:#fff;padding:10px 15px;border-radius:6px;text-decoration:none;cursor:pointer;margin-top:10px;}
.btn:hover{background:#219150;}
@media print {
    .btn, a {display:none;}
    body{background:#fff;padding:0;}
    .container{box-shadow:none;border-radius:0;}
}
</style>
</head>
<body>
<div class="container">
<h2>Struk Transaksi</h2>
<p><strong>Kasir:</strong> <?= htmlspecialchars($transaksi['kasir']) ?></p>
<p><strong>Tanggal:</strong> <?= $tanggal_only ?></p>

<table>
<thead>
<tr><th>Produk</th><th>Qty</th><th>Harga</th><th>Subtotal</th></tr>
</thead>
<tbody>
<?php while($d = mysqli_fetch_assoc($details)){ ?>
<tr>
<td><?= htmlspecialchars($d['nama_produk']) ?></td>
<td><?= $d['qty'] ?></td>
<td>Rp <?= number_format($d['harga'],0,',','.') ?></td>
<td>Rp <?= number_format($d['subtotal'],0,',','.') ?></td>
</tr>
<?php } ?>
</tbody>
<tfoot>
<tr><td colspan="3">Total</td><td>Rp <?= number_format($transaksi['total_harga'],0,',','.') ?></td></tr>
<tr><td colspan="3">Bayar</td><td>Rp <?= number_format($transaksi['bayar'],0,',','.') ?></td></tr>
<tr><td colspan="3">Kembalian</td><td>Rp <?= number_format($transaksi['kembalian'],0,',','.') ?></td></tr>
</tfoot>
</table>

<button class="btn" onclick="window.print()">🖨️ Cetak Struk</button>
<a href="dashboard_kasir.php" class="btn">← Kembali ke Dashboard</a>
</div>
</body>
</html>
