<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'kasir'){
    header("Location: ../login.php");
    exit;
}

$produk = mysqli_query($koneksi,"SELECT * FROM produk ORDER BY id_produk ASC");

// Limit untuk stok menipis
$stok_limit = 5;

// Cek stok menipis untuk notifikasi
$stok_menipis = [];
while($p = mysqli_fetch_assoc($produk)){
    if($p['stok'] <= $stok_limit){
        $stok_menipis[] = $p['nama_produk'];
    }
}
// Reset pointer untuk tabel
mysqli_data_seek($produk, 0);
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Daftar Produk - Elino.Computer</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
body,html{margin:0;padding:0;font-family:'Segoe UI',sans-serif;background:#e2e8f0;}

/* Header */
.header{
    background:#0f172a;
    color:#fff;
    padding:25px 30px;
    text-align:center;
    font-size:22px;
    box-shadow:0 4px 12px rgba(0,0,0,0.2);
}
.header span{color:#38bdf8;font-weight:bold;}

/* Sidebar */
.sidebar{
    width:220px;
    background:#1e293b;
    color:#fff;
    position:fixed;
    top:0; left:0;
    height:100%;
    padding-top:90px;
}
.sidebar h3{text-align:center;margin-bottom:20px;font-size:18px;color:#f3f4f6;}
.sidebar a{
    display:flex;
    align-items:center;
    color:#e5e7eb;
    padding:12px 20px;
    text-decoration:none;
    transition:0.3s;
}
.sidebar a:hover{background:#2563eb;color:#fff;border-radius:8px;}
.sidebar a i{margin-right:10px;}

/* Content */
.content{margin-left:220px;padding:30px;}

/* Container */
.container{
    background:#fff;
    padding:25px;
    border-radius:12px;
    box-shadow:0 6px 16px rgba(0,0,0,0.15);
}
h2{text-align:center;color:#0f172a;}

/* Buttons */
.btn-filter{
    padding:8px 15px;
    background:#f59e0b;
    color:white;
    border:none;
    border-radius:6px;
    cursor:pointer;
    margin-bottom:15px;
}
.btn-filter:hover{background:#d97706;}

/* Table */
table{
    width:100%;
    border-collapse:collapse;
    margin-top:20px;
    background:#fff;
    border-radius:10px;
    overflow:hidden;
    box-shadow:0 4px 12px rgba(0,0,0,0.1);
}
th,td{padding:12px;text-align:center;border-bottom:1px solid #ddd;}
th{background:#0f172a;color:white;}
tr:hover{background:#f1f5f9;}

/* Stok menipis */
.stok-rendah{background:#fee2e2;color:#b91c1c;font-weight:bold;}

/* Notifikasi */
.notif{
    background:#fef3c7;
    border:1px solid #fde68a;
    color:#92400e;
    padding:15px;
    border-radius:8px;
    margin-bottom:15px;
}
.notif ul{margin:0;padding-left:20px;}

/* PAGINATION */
.pagination {
    display: flex;
    justify-content: center;
    margin-top: 20px;
    gap: 5px;
}
.pagination button {
    background: #fff;
    border: 1px solid #ddd;
    padding: 8px 14px;
    cursor: pointer;
    border-radius: 6px;
    transition: 0.3s;
    color: #333;
    font-weight: 500;
}
.pagination button.active {
    background: #0d6efd;
    color: white;
    border-color: #0d6efd;
}
.pagination button:hover:not(.active) {
    background: #f1f5f9;
}
.pagination button:disabled {
    cursor: not-allowed;
    opacity: 0.6;
}
</style>
</head>
<body>

<div class="header">🖥️ <span>Elino.Computer</span> - Produk Kasir</div>

<div class="sidebar">
<h3>Menu Kasir</h3>
<a href="dashboard_kasir.php"><i class="fa fa-tachometer-alt"></i> Dashboard</a>
<a href="transaksi.php"><i class="fa fa-cart-plus"></i> Transaksi Baru</a>
<a href="lihat_produk.php"><i class="fa fa-box"></i> Lihat Produk</a>
<a href="../logout.php"><i class="fa fa-right-from-bracket"></i> Logout</a>
</div>

<div class="content">
<div class="container">

<h2>📦 Daftar Produk</h2>

<?php if(count($stok_menipis) > 0): ?>
<div class="notif">
⚠️ Stok menipis untuk produk:
<ul>
<?php foreach($stok_menipis as $nama){ ?>
    <li><?= htmlspecialchars($nama) ?></li>
<?php } ?>
</ul>
</div>
<?php endif; ?>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <div style="position: relative; width: 350px;">
        <i class="fa fa-search" style="position: absolute; left: 15px; top: 12px; color: #aaa;"></i>
        <input type="text" id="cariProduk" placeholder="Cari nama produk..." onkeyup="handleSearch()" style="width: 100%; padding: 10px 10px 10px 40px; border-radius: 8px; border: 1px solid #ccc; font-size: 14px;">
    </div>
    <div style="display:flex; gap:10px;">
        <button class="btn-filter" onclick="filterStokMenipis()" style="background:#f59e0b; margin:0;"><i class="fa fa-exclamation-triangle"></i> Stok Menipis</button>
        <button class="btn-filter" onclick="tampilkanSemua()" style="background:#0d6efd; margin:0;"><i class="fa fa-list"></i> Semua</button>
    </div>
</div>

<table id="tabelProduk">
<thead>
<tr>
    <th>ID</th>
    <th>Nama Produk</th>
    <th>Harga</th>
    <th>Stok</th>
</tr>
</thead>
<tbody>
<?php while($p=mysqli_fetch_assoc($produk)) { ?>
<tr class="item-produk">
    <td><?= $p['id_produk'] ?></td>
    <td class="nama-produk"><?= htmlspecialchars($p['nama_produk']) ?></td>
    <td>Rp <?= number_format($p['harga'],0,',','.') ?></td>
    <td class="<?= $p['stok'] <= $stok_limit ? 'stok-rendah' : '' ?>">
        <?= $p['stok'] ?>
    </td>
</tr>
<?php } ?>
</tbody>
</table>

<!-- Pagination Controls -->
<div class="pagination" id="paginationControls"></div>

</div>
</div>

<script>
// Logic Pagination & Search
const rowsPerPage = 10;
let currentPage = 1;
const allRows = Array.from(document.querySelectorAll('.item-produk'));
let filteredRows = [...allRows];

function renderTable() {
    // Hide all first
    allRows.forEach(row => row.style.display = 'none');

    // Calculate pagination
    const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
    if(currentPage > totalPages) currentPage = 1;
    if(currentPage < 1) currentPage = 1;

    // Show current page items
    const start = (currentPage - 1) * rowsPerPage;
    const end = start + rowsPerPage;
    const pageItems = filteredRows.slice(start, end);
    
    pageItems.forEach(row => row.style.display = '');

    renderPagination(totalPages);
}

function renderPagination(totalPages) {
    const container = document.getElementById('paginationControls');
    container.innerHTML = '';

    if(totalPages <= 1) return;

    // Prev Button
    const btnPrev = document.createElement('button');
    btnPrev.innerText = 'Prev';
    btnPrev.type = 'button';
    btnPrev.onclick = () => { if(currentPage > 1) { currentPage--; renderTable(); } };
    if(currentPage === 1) btnPrev.disabled = true;
    container.appendChild(btnPrev);

    // Page Numbers
    for(let i=1; i<=totalPages; i++) {
        const btn = document.createElement('button');
        btn.innerText = i;
        btn.type = 'button';
        if(i === currentPage) btn.classList.add('active');
        btn.onclick = () => { currentPage = i; renderTable(); };
        container.appendChild(btn);
    }

    // Next Button
    const btnNext = document.createElement('button');
    btnNext.innerText = 'Next';
    btnNext.type = 'button';
    btnNext.onclick = () => { if(currentPage < totalPages) { currentPage++; renderTable(); } };
    if(currentPage === totalPages) btnNext.disabled = true;
    container.appendChild(btnNext);
}

function handleSearch() {
    const input = document.getElementById('cariProduk');
    const filter = input.value.toUpperCase();

    filteredRows = allRows.filter(row => {
        const td = row.querySelector('.nama-produk');
        if(td) {
            const txtValue = td.textContent || td.innerText;
            return txtValue.toUpperCase().indexOf(filter) > -1;
        }
        return false;
    });

    currentPage = 1; // Reset to page 1 on search
    renderTable();
}

// Logic Stok Menipis (Reuse filter logic)
function filterStokMenipis(){
    const limit = <?= $stok_limit ?>;
    filteredRows = allRows.filter(row => {
        const stok = parseInt(row.querySelector('td:nth-child(4)').innerText); // 4th column is stok
        return stok <= limit;
    });
    currentPage = 1;
    renderTable();
}

function tampilkanSemua(){
    filteredRows = [...allRows];
    document.getElementById('cariProduk').value = '';
    currentPage = 1;
    renderTable();
}

// Initial Render
renderTable();
</script>

</body>
</html>
