<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'admin'){
    header("Location: ../login.php");
    exit;
}

$users = mysqli_query($koneksi,"SELECT * FROM users ORDER BY id_user ASC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Kelola User • Elino Computer</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<style>
/* RESET & GLOBAL */
*{box-sizing:border-box;margin:0;padding:0;}
body{font-family:'Poppins', sans-serif;background:#f4f6fc;color:#333;}
a{text-decoration:none;}
button{cursor:pointer;}

/* HEADER */
.header{
    background:linear-gradient(135deg,#0d6efd,#084298);
    color:#fff;
    padding:25px 20px;
    text-align:center;
    font-size:24px;
    font-weight:600;
    letter-spacing:1px;
    box-shadow:0 2px 6px rgba(0,0,0,0.15);
}

/* SIDEBAR */
.sidebar{
    width:240px;
    background:#1e1e2f;
    color:#fff;
    position:fixed;
    top:0;
    left:0;
    height:100vh;
    padding-top:90px;
    transition: width 0.3s;
}
.sidebar h3{
    text-align:center;
    margin-bottom:25px;
    font-weight:500;
    color:#cfd2ff;
    font-size:18px;
}
.sidebar a{
    display:block;
    padding:15px 25px;
    color:#ddd;
    font-weight:500;
    transition:0.3s;
    border-left:4px solid transparent;
}
.sidebar a:hover{
    background:#343aeb;
    color:#fff;
    padding-left:30px;
    border-left:4px solid #fff;
}

/* CONTENT */
.content{
    margin-left:240px;
    padding:30px 35px;
}
.content h3{
    margin-bottom:20px;
}

/* BUTTON TAMBAH */
.btn-tambah{
    display:inline-block;
    background:#28a745;
    color:#fff;
    padding:8px 18px;
    border-radius:8px;
    text-decoration:none;
    margin-bottom:20px;
    font-weight:500;
    transition:0.3s;
}
.btn-tambah:hover{
    background:#218838;
}

/* TABLE */
table{
    width:100%;
    border-collapse:collapse;
    background:#fff;
    border-radius:12px;
    overflow:hidden;
    box-shadow:0 10px 25px rgba(0,0,0,0.08);
}
th{
    background:#0d6efd;
    color:#fff;
    padding:14px;
    font-weight:500;
    font-size:14px;
    text-align:left;
}
td{
    padding:12px 14px;
    font-size:14px;
    border-bottom:1px solid #eee;
}
tr:hover{
    background:#f0f4ff;
}

/* AKSI BUTTON */
.aksi a{
    display:inline-block;
    padding:6px 14px;
    color:white;
    border-radius:6px;
    text-decoration:none;
    margin:0 4px;
    font-size:13px;
    font-weight:500;
    transition:0.3s;
}
.edit{background:#0d6efd;}
.edit:hover{background:#0056b3;}
.hapus{background:#dc3545;}
.hapus:hover{background:#b02a37;}
.lihat{background:#ffc107;color:#212529;}
.lihat:hover{background:#e0a800;color:#212529;}

/* BADGE STATUS */
.badge {
    padding: 5px 12px;
    border-radius: 20px;
    color: #fff;
    font-size: 12px;
    font-weight: 600;
    display: inline-block;
    min-width: 60px;
    text-align: center;
    transition: all 0.3s ease;
}
.badge-online { background: #28a745; box-shadow: 0 0 10px rgba(40, 167, 69, 0.4); }
.badge-offline { background: #6c757d; }

@keyframes pulse {
    0% { transform: scale(0.95); opacity: 0.7; }
    50% { transform: scale(1.05); opacity: 1; }
    100% { transform: scale(0.95); opacity: 0.7; }
}

</style>
</head>
<body>

<div class="header">
    <h2>User • Elino Computer</h2>
    <div id="realtime-clock" style="font-size: 14px; font-weight: 400; opacity: 0.9; margin-top: 5px;"></div>
</div>


<div class="sidebar">
    <h3>Menu Admin</h3>
    <a href="index.php">Dashboard</a>
    <a href="users.php">Kelola User</a>
    <a href="produk.php">Kelola Produk</a>
    <a href="transaksi.php">Transaksi</a>
    <a href="laporan.php">Laporan</a>
    <a href="../logout.php">Logout</a>
</div>


<div class="content">
            <div style="display: flex; align-items: center; justify-content: space-between;">
                <h3>Kelola User</h3>
                <div style="font-size: 12px; color: #28a745; display: flex; align-items: center;">
                    <span style="width: 8px; height: 8px; background: #28a745; border-radius: 50%; display: inline-block; margin-right: 6px; animation: pulse 1.5s infinite;"></span>
                    Live Update Aktif
                </div>
            </div>


    <a href="tambah_user.php" class="btn-tambah">+ Tambah User</a>

    <table>
        <tr>
            <th>ID</th>
            <th>Nama</th>
            <th>Username</th>
            <th>Role</th>
            <th>Status</th>
            <th>Aksi</th>
        </tr>
        <?php while($u = mysqli_fetch_assoc($users)){ 
            // Cek status online (batas 5 menit / 300 detik)
            $is_online = false;
            $last_seen = "-";
            
            if($u['last_activity']){
                $time_idle = time() - strtotime($u['last_activity']);
                if($time_idle < 300){
                    $is_online = true;
                }
                $last_seen = date('d/m/Y H:i', strtotime($u['last_activity']));
            }
        ?>
        <tr>
            <td><?= $u['id_user'] ?></td>
            <td><?= htmlspecialchars($u['nama']) ?></td>
            <td><?= htmlspecialchars($u['username']) ?></td>
            <td><?= htmlspecialchars($u['role']) ?></td>
            <td id="status-<?= $u['id_user'] ?>">
                <?php if($is_online): ?>
                    <span class="badge badge-online">Online</span>
                <?php else: ?>
                    <span class="badge badge-offline">Offline</span>
                <?php endif; ?>
            </td>

            <td class="aksi">
                <?php if($u['role'] == 'admin'): ?>
                    <a href="profil.php?id=<?= $u['id_user'] ?>" class="lihat" style="background:#17a2b8;">Profil</a>
                    <a href="edit_user.php?id=<?= $u['id_user'] ?>" class="edit">Edit Profil</a>
                <?php else: ?>
                    <a href="edit_user.php?id=<?= $u['id_user'] ?>" class="edit">Edit</a>
                    
                    <?php if($is_online): ?>
                        <a href="force_offline.php?id=<?= $u['id_user'] ?>" class="hapus" style="background:#fd7e14;" onclick="return confirm('Paksa offline user ini?')">Force Offline</a>
                    <?php endif; ?>

                    <a href="hapus_user.php?id=<?= $u['id_user'] ?>" 
                       class="hapus"
                       onclick="return confirm('Hapus user ini?')">Hapus</a>
                <?php endif; ?>
            </td>



        </tr>
        <?php } ?>
    </table>
</div>

<script>
// Tampilkan Jam Realtime di Header
function updateClock() {
    const now = new Date();
    const days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
    const months = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
    
    const dayName = days[now.getDay()];
    const day = now.getDate();
    const month = months[now.getMonth()];
    const year = now.getFullYear();
    const h = String(now.getHours()).padStart(2, '0');
    const m = String(now.getMinutes()).padStart(2, '0');
    const s = String(now.getSeconds()).padStart(2, '0');
    
    document.getElementById('realtime-clock').innerHTML = `${dayName}, ${day} ${month} ${year} | <strong style="font-size:16px;">${h}:${m}:${s}</strong>`;
}

let userStatusData = [];

function timeAgo(unix, serverUnix) {
    if(!unix) return "Belum pernah aktif";
    // Hitung diff berdasarkan selisih server + selisih waktu lokal sejak update terakhir
    const now = Math.floor(Date.now() / 1000);
    const diff = serverUnix - unix;
    
    if (diff < 5) return "Baru saja";
    if (diff < 60) return diff + " detik yang lalu";
    if (diff < 3600) return Math.floor(diff / 60) + " menit yang lalu";
    if (diff < 86400) return Math.floor(diff / 3600) + " jam yang lalu";
    return Math.floor(diff / 86400) + " hari yang lalu";
}

function renderStatus() {
    userStatusData.forEach(user => {
        const container = document.getElementById('status-' + user.id_user);
        if(container) {
            // Selisih waktu sejak data diambil (threshold 90s)
            const timeSinceLastUpdate = Math.floor((Date.now() - user.localFetchTime) / 1000);
            const currentDiff = (user.server_unix - user.last_unix) + timeSinceLastUpdate;
            const isActuallyOnline = (user.last_unix > 0 && currentDiff < 90);

            let html = '';
            if(isActuallyOnline) {
                html = '<span class="badge badge-online">Online</span>';
            } else {
                html = '<span class="badge badge-offline">Offline</span>';
            }
            container.innerHTML = html;
        }
    });
}


function updateStatus() {
    fetch('api_get_users_status.php')
    .then(response => response.json())
    .then(data => {
        if(data.error) return;
        const now = Date.now();
        userStatusData = data.map(u => ({...u, localFetchTime: now}));
        renderStatus();
    })
    .catch(err => console.error('Error fetching status:', err));
}

// Jalankan jam setiap detik
setInterval(updateClock, 1000);
updateClock();

// Render ulang tampilan setiap detik (untuk efek ticking)
setInterval(renderStatus, 1000);

// Ambil data baru dari server setiap 5 detik
setInterval(updateStatus, 5000);
updateStatus();



// Heartbeat setiap 1 menit agar admin tetap online
setInterval(() => {
    fetch('../heartbeat.php');
}, 60000);
</script>

</body>
</html>


