<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'admin'){
    header("Location: ../login.php"); 
    exit;
}

if(!isset($_GET['id'])){
    header("Location: produk.php");
    exit;
}

$id = intval($_GET['id']);
$query = mysqli_query($koneksi,"SELECT * FROM produk WHERE id_produk='$id'");
if(mysqli_num_rows($query) == 0){
    die("Produk tidak ditemukan!");
}
$p = mysqli_fetch_assoc($query);

if(isset($_POST['update'])){
    $nama_produk = mysqli_real_escape_string($koneksi,$_POST['nama_produk']);
    $harga = mysqli_real_escape_string($koneksi,$_POST['harga']);
    $stok = mysqli_real_escape_string($koneksi,$_POST['stok']);

    if($nama_produk && $harga >= 0 && $stok >= 0){
        $update = mysqli_query($koneksi,"UPDATE produk SET nama_produk='$nama_produk', harga='$harga', stok='$stok' WHERE id_produk='$id'");
        if($update){
            header("Location: produk.php"); // Redirect langsung ke daftar produk
            exit;
        } else {
            $error = "Gagal update: ".mysqli_error($koneksi);
        }
    } else {
        $error = "Harap isi semua field dengan benar!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edit Produk • Elino Computer</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<style>
/* GLOBAL */
*{box-sizing:border-box;margin:0;padding:0;}
body{font-family:'Poppins',sans-serif;background:#f4f6fc;color:#333;}
a{text-decoration:none;}

/* HEADER */
.header{
    background:linear-gradient(135deg,#0d6efd,#084298);
    color:#fff;
    padding:25px 20px;
    text-align:center;
    font-size:24px;
    font-weight:600;
    letter-spacing:1px;
    box-shadow:0 2px 6px rgba(0,0,0,0.15);
}

/* SIDEBAR */
.sidebar{
    width:240px;
    background:#1e1e2f;
    color:#fff;
    position:fixed;
    top:0;
    left:0;
    height:100vh;
    padding-top:90px;
}
.sidebar h3{
    text-align:center;
    margin-bottom:25px;
    font-weight:500;
    color:#cfd2ff;
    font-size:18px;
}
.sidebar a{
    display:block;
    padding:15px 25px;
    color:#ddd;
    font-weight:500;
    transition:0.3s;
    border-left:4px solid transparent;
}
.sidebar a:hover{
    background:#343aeb;
    color:#fff;
    padding-left:30px;
    border-left:4px solid #fff;
}

/* CONTENT */
.content{
    margin-left:240px;
    padding:30px 35px;
}
.content h3{
    margin-bottom:20px;
}

/* FORM CONTAINER */
.form-container{
    background:#fff;
    padding:30px;
    border-radius:12px;
    box-shadow:0 10px 25px rgba(0,0,0,0.08);
    max-width:500px;
    margin:auto;
}
.form-container h3{
    text-align:center;
    color:#0d6efd;
    margin-bottom:25px;
    font-weight:600;
}
.form-container label{
    display:block;
    margin-top:15px;
    font-weight:500;
}
.form-container input{
    width:100%;
    padding:12px;
    margin-top:5px;
    border-radius:8px;
    border:1px solid #ccc;
    font-size:14px;
}
.form-container button{
    width:100%;
    margin-top:25px;
    padding:12px;
    background:#ffc107;
    color:#fff;
    border:none;
    border-radius:8px;
    cursor:pointer;
    font-weight:500;
    transition:0.3s;
}
.form-container button:hover{
    background:#e0a800;
}
.back-link{
    display:block;
    text-align:center;
    margin-top:20px;
    color:#0d6efd;
    text-decoration:none;
    font-weight:500;
}
.back-link:hover{
    text-decoration:underline;
}
.error{
    color:red;
    text-align:center;
    margin-bottom:15px;
    font-weight:500;
}
</style>
</head>
<body>

<div class="header">Edit Produk • Elino Computer</div>

<div class="sidebar">
    <h3>Menu Admin</h3>
    <a href="index.php">Dashboard</a>
    <a href="users.php">Kelola User</a>
    <a href="produk.php">Kelola Produk</a>
    <a href="transaksi.php">Transaksi</a>
    <a href="../logout.php">Logout</a>
</div>

<div class="content">
    <div class="form-container">
        <h3>Edit Produk</h3>
        <?php if(!empty($error)) echo "<p class='error'>$error</p>"; ?>
        <form method="POST">
            <label>Nama Produk</label>
            <input type="text" name="nama_produk" value="<?= htmlspecialchars($p['nama_produk']); ?>" required>

            <label>Harga</label>
            <input type="number" name="harga" value="<?= $p['harga']; ?>" min="0" required>

            <label>Stok</label>
            <input type="number" name="stok" value="<?= $p['stok']; ?>" min="0" required>

            <button type="submit" name="update">Update Produk</button>
        </form>
        <a href="produk.php" class="back-link">← Kembali ke Daftar Produk</a>
    </div>
</div>

</body>
</html>
